# 光泽度测量技巧

本部分提供关于**何时使用标准光泽度（Gloss）或视觉光泽度（Visual Gloss）**的建议，以及**传感器放置和校准**的技巧。

## 测量建议

- **确保仪器与表面平行放置**，避免倾斜影响测量结果。
- **定期校准仪器**，建议每天至少校准一次，以确保测量准确性。
- **测量曲面时**，请使用**曲面测量适配器**并**启用交互式测量功能**，以获得最佳测量效果。

---

## 曲面测量建议

- **不建议使用标准光泽适配器测量曲率半径小于 0.5m 的曲面**。
- **仪器标配曲面/小面积测量适配器**，将测量区域缩小至 **2×4mm**，适用于**小半径曲面**。

---

## 复杂部件测量建议

对于**复杂形状或小半径部件**，手动放置仪器可能较难，建议采用以下方法：

- **使用非接触测量方式**（例如测量支架或协作机器人）。
- **利用实时定位反馈**，确保正确的测量位置。
- **为高度可重复的测量结果，建议使用 3D 打印夹具**，确保部件放置在正确位置。

---

## 小面积测量建议

- 对于**小面积测量**，请使用**曲面/小部件适配器**。
- **在测量前，利用交互式测量功能进行精确定位**。

---

## 标准光泽的局限性（与视觉光泽相比）

- **标准光泽测量无法准确匹配客户对不同颜色材料的感知光泽**。
- **单独测量光泽度无法检测影响高光泽材料外观质量的表面缺陷**，如：
    - **雾影（Haze）**
    - **橘皮效应（Orange Peel）**
    - **表面清晰度（Sharpness）不足**

---

## 测量技巧——何时使用标准光泽度测量

- **适用于已有光泽度规范的质量控制**  
  Aesthetix **标准光泽测量符合 ISO 和 ASTM 国际标准**，可用于符合性检测。

- **与客户现有仪器保持一致**  
  Aesthetix 60° 光泽值**与 Rhopoint IQ、NG 光泽计或 BYK Micro Gloss 仪器的测量值高度一致**。

- **当需要定量测量表面光反射率时**  
  标准光泽度测量提供**数值化的反射光强度数据**，适用于特定技术要求的环境。

- **当需要更符合人眼感知的光泽测量时**，应**使用视觉光泽（Visual Gloss）**。

- **对于高光泽表面**，相比标准光泽测量：
    - **雾影（Haze）**
    - **清晰度（Sharpness）**
    - **波纹度（Waviness）**
    - **往往是更好的表面质量指标**。

---

## 测量技巧——标准光泽测量的重要性

- **与现有测量数据的兼容性**  
  标准光泽测量**完全符合 ISO 和 ASTM 国际标准**，可与历史数据无缝衔接。

- **法规和技术要求**  
  许多行业规定了必须达到的**光泽标准**。  
  在这种情况下，使用光泽计测量可确保产品符合**技术规范**和**法规要求**。
