# Quick Start Guide

## Minimum System Requirements
- OS – Windows 10 (windows 10.0.22621.0)/ Windows 11
- 8GB Memory
- USB 3.0 USB-C or Thunderbolt port
- Recommended 1920 x 1080 screen resolution 

## Installation
- Insert USB stick that contains the software.
- Double-click the MSI package to install the software.
- Follow the on-screen instructions.
- Once installed connect the instrument to the PC using a USB 3.0 or above port (USB-C) and run the program from the desktop shortcut. 

## Basic Software Use

### Home Screen
![](home-screen.png)

#### Software Version and Updates
The current version is shown in the lower right corner of the home screen, if any updates are available this will be shown with an exclamation mark symbol. Updates can be applied by clicking the icon.

#### Licence Manager
This takes you to the Licence Manager screen where licence information is available, this includes licence type, name and validity information.

#### Optimap Reader View
This takes you to the Optimap Reader View, this is used to open Optimap projects and files and is not a feature for the Aesthetix. 

## Device View
This takes you to the Device screen where you can access and connect any devices that are available. Press the connection button to open the available devices screen.
![](connect-device-button.png)

### Available Devices
![](available-devices.png)
Here you will see the available devices and information about the selected device. Press connect to complete the connection process, when the symbol changes to the connected icon press ok.
![](available-device.png)

## Module Test Screen
![](module-test-screen.png)
This is where the instrument can be calibrated and measurements performed, data analysis and organisation are also available. 

| Button                     | Description                                                                                                                                                                                                           |
|----------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| ![](measure-button.png)    | Read Button: Press to take a reading, the button will animate while a reading is being taken. Pressing the arrow next to the button enables the multi read function. Right click to set number of readings and delay. |
| ![](calibrate-button.png)  | Calibrate Button: Press to calibrate to supplied standard, follow on screen instructions. The calibration values can be updated by pressing the unlock values button.                                                 |
| ![](live-view-button.png)  | Live View: Allows Live View of both cameras to allow precise positioning of read area.                                                                                                                                |
| ![](table-view-button.png) | Table View: Press to return to the data table view, this is visible only when the table is not visible, for example in Live View mode.                                                                                |

### Modules
![](modules-bar.png)
Available modules are shown in blue, hovering the cursor over the icon shows the module name.

### Data Control

| Button                           | Description                                                                                                                                                                            |
|----------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| ![](save-button.png)             | Save Button: Press to save all data, this will take you to the save screen where you will have to select a folder to save your data to, this should be unique to the data set.         |
| ![](load-button.png)             | Open Button: Press to open saved data.                                                                                                                                                 |
| ![](save-to-database-button.png) | Save to Database: Save data to the selected database.                                                                                                                                  |
| ![](load-from-database.png)      | Load Database: Load from database.                                                                                                                                                     |
| ![](settings-button.png)         | Settings Button: Press to enable a reference standard, the reference standard is based on a measurement already taken. Right click on a measurement in the table to set as a standard. |
| ![](delete-button.png)           | Delete Button: Press to delete all readings in the table or drag individual readings here to delete individually.                                                                      |

## Data Management

### Batching
![](batching.png)
Right click on a single measurement or selected measurements for batching options.

### Database
![](database-links.png)
Click the dotted circle to add a result/measurement to the database, the circle will animate momentarily.

![](database-links-active.png)
The circle will turn blue and a D will appear in the centre, the data is now in the database.