# File Identification

The RAE file format begins with a specific sequence of bytes to uniquely identify the file type and its version. This sequence is known as the magic string. The purpose of the magic string is to allow software tools to quickly recognize and validate the file format before attempting to process it.

The magic string structure is as follows:  
`RAE<version byte>CBOR<0xFF>`

### Breakdown of the Magic String
1. **`RAE`**:  
   A fixed three-character prefix that identifies the file as an RAE format file.

2. **Version Byte** (`<version byte>`):  
   A single byte that specifies the version of the RAE format. This allows for future backward-compatible updates to the format.
    - The current version is `0x01`, indicating the initial version of the RAE format.

3. **`CBOR`**:  
   A variable length string indicating that the file's data container uses the CBOR (Concise Binary Object Representation) encoding format.

4. **Terminator Byte** (`<0xFF>`):  
   A single byte with the value `0xFF`, marking the end of the magic string and the start of the file header. This ensures unambiguous parsing and serves as a delimiter for file processing tools.

### Example
An example of the magic string in a hexadecimal representation for the current version (`0x01`) would look like this:  
`52 41 45 01 43 42 4F 52 FF`

- `52 41 45`: ASCII for "RAE".
- `01`: Version byte (current version).
- `43 42 4F 52`: ASCII for "CBOR".
- `FF`: Terminator byte.

This sequence is the first part of the file and ensures that any system or tool attempting to parse the file can quickly verify its format, version, and encoding type.
