# Effects Finish Module
Effect Finish Module quantifies the sparkle and graininess visible in materials containing effect pigments.

## Graininess

Graininess is a visual texture perceived as a non-uniform, granular pattern on a surface when viewed under diffuse lighting conditions.

It appears as a subtle variation in lightness or darkness across the surface, giving it a grainy or coarse look. 

This texture is particularly noticeable in materials with effect pigments, which scatter light in various directions, creating an uneven appearance. 


| Graininess | Surface                | Description/Perception                                                                   |
|------------|------------------------|------------------------------------------------------------------------------------------|
| <1         | Smooth Appearance      | Very little Graininess- surface looks like a solid colour in diffuse lighting conditions |
| 1-3        | Fine Grain             | A fine grain is visible in diffuse conditions.                                           |
| 3-6        | Coarse Appearance      | Graininess apparent under diffuse lighting conditions                                    |
| 6+         | Very Grainy Appearance | Highly coarse, mottled appearance                                                        |

**Measurement Method**
A single image of the surface that represents its intrinsic colour, independent of lighting conditions, shadows, and other effects like reflections or shading is derived.

The graininess is quantified by analysing the spatial variation in the luminance factor of the derived image, focusing on intermediate spatial frequencies that capture the local reflectance variations.

The graininess scale includes a factor that accounts for the average luminance of the surface, making it possible to compare the graininess of materials with different levels of reflectance. This scale has been psycho metrically tested and shown to correlate well with subjective human perception, providing a reliable measure of the graininess of various materials. 

## Sparkle

Sparkle refers to a visual texture observed when mirror like elements within a surface reflect light it is seen as tiny, bright points of light that appear strikingly brighter than their surroundings, akin to stars in the night sky or sunlight glittering on water. 

The term is often used to describe materials with effect pigments that create this vivid, shimmering appearance under directional illumination. 

Sparkle tends to decrease with the shift towards diffuse illumination and disappears under completely diffuse conditions. 

## Sparkle Density

Sparkle Density 

Sparkle density is a measure of the concentration of visible sparkle points on a surface when viewed under directional lighting conditions. It quantifies how many of these bright points are visible on average in the 100mm2 (10mmx10mm) field of measurement in each of the six images.

## Sparkle Visibility
Visibility

The Aesthetix reports sparkle visibility- an average intensity value for any sparkling elements which have been identified as visible in the material.
Note- The visual visibility of sparkle elements is proportionate to the luminosity of the light source- for example elements are seen as brighter and more visible in strong sunlight compared to LED spotlights. 

## Sparkle Area
Area
The Aesthetix reports sparkle area corresponding to the field of measurement (10x10mm) as an average size value for any sparkling elements which have been identified as visible.

Each visible element is identified and its size in pixels is calculated and converted into 

## Sparkle Color
**SpR, SpG, SpB**
Color values in RGB for the average color of the sparkling elements in th field of measurement

## Measurement Method
**Image Acquisition**
Six images of the surface are captured, each lit with one of the 45° ring lights.

| e.g., from the right (LED 1) | and from the left (LED 4)  |
|------------------------------|----------------------------|
| ![LED 1](sparkle-led1.png)   | ![LED 2](sparkle-led4.png) |
  

The images record the brightness of each point on the surface under each specific directional illumination (LED 1-6) in a 10x10 rectangle (Red area)

The LEDs are color coded in the graphs as given in the selection boxes below, with similar colors being opposite LEDs, e.g., Magenta (LED 1 and LED 4)
![LED selection](sparkle-led-selection.png)

**Identification of Sparkle Points**
The sparkle points are identified in the image by distinguishing areas that have a brightness significantly higher than their surrounding background.
![Sparkle visibility graph](sparkle-visibility-graph.png)

A sparkle point is considered "visible" if its contrast relative to the background exceeds a certain threshold.

The threshold has been determined by a visibility formula that incorporates factors like the luminance of the sparkle point, the background luminance, the size of the sparkle point, and the viewing distance. 

**Counting Visible Sparkle Points**
Once the visible sparkle points are identified, the total number of these points within the image is counted.
