# 效果饰面模块（Effects Finish Module）

效果饰面模块用于量化含有效果颜料的材料中可见的闪烁和颗粒感。

## 颗粒感

颗粒感是指在漫射光照条件下，表面呈现的**非均匀、颗粒状纹理**，  
表现为表面亮度或暗度的微小变化，使其看起来粗糙或颗粒状。

这种视觉效果在**含有效果颜料的材料**中尤为明显，  
因其散射光线的方式不同，会导致表面出现不均匀的视觉质感。

| 颗粒感数值 | 表面质量   | 视觉感知描述                 |
|-------|--------|------------------------|
| <1    | 平滑外观   | 颗粒感极低，在漫射光下表面看起来像纯色表面。 |
| 1-3   | 细颗粒    | 在漫射光下可见微细颗粒纹理。         |
| 3-6   | 粗糙外观   | 在漫射光下明显可见颗粒感。          |
| 6+    | 高颗粒感外观 | 颗粒纹理高度明显，呈现不均匀、斑驳的表面。  |

### 测量方法

系统获取**独立于光照条件、阴影和反射效应的表面图像**，提取材料的固有颜色信息。  
颗粒感数值通过分析图像的**亮度因子变化**计算，专注于**中等空间频率范围内的反射变化**。

颗粒感测量采用**光亮度补偿因子**，可用于不同反射率材料的对比。  
该测量方法经过心理物理实验验证，与人眼感知高度匹配，可稳定测量不同材料的颗粒感。

---

## 闪烁感

闪烁感是指表面**镜面微粒反射光线**的视觉效果，  
通常表现为**明亮的光点**，类似夜空中的星光或水面上的阳光闪烁。

此现象常见于**含有效果颜料的材料**，当材料在**定向照明下**观察时，  
其闪烁感尤为明显，而在**完全漫射光照条件下，闪烁感会消失**。

---

## 闪烁密度

闪烁密度表示在**定向光照条件下**，**可见闪烁点的数量**。

- 以**每 100mm²（10mm x 10mm）测量区域**为单位，  
  统计六张测量图像中的平均闪烁点数。

---

## 闪烁可见性

Aesthetix 计算**闪烁可见性**，即**材料中可见闪烁点的平均亮度值**。

**注意**：  
闪烁点的视觉可见性**与光源亮度成正比**。  
例如，在**强烈阳光下，闪烁点比 LED 聚光灯照射时更亮、更明显**。

---

## 闪烁面积

闪烁面积是指在**10x10mm 测量区域内**，**可见闪烁点的平均尺寸**。

系统通过图像分析识别每个可见闪烁点，计算其像素大小，并换算为物理单位。

---

## 闪烁颜色

**SpR, SpG, SpB**  
系统提供**RGB 颜色值**，表示测量区域内**所有可见闪烁点的平均颜色**。

---

## 测量方法

### 图像采集

系统使用**45° 环形光源**，拍摄六张表面图像，每张图像由不同方向的 LED 照明。

| 右侧照明（LED 1）          | 左侧照明（LED 4）          |
|---------------------------|---------------------------|
| ![LED 1](sparkle-led1.png) | ![LED 2](sparkle-led4.png) |

测量图像记录了表面各点在不同方向光源下的亮度分布（LED 1-6）。  
测量区域为**10x10mm 红色矩形区域**。

LED 在图表中以颜色编码标识，  
相对位置相同的 LED 具有相同颜色（例如，LED 1 和 LED 4 均为品红色）。  
![LED 选择](sparkle-led-selection.png)

---

### 闪烁点识别

系统**通过亮度对比度分析**，识别图像中的**闪烁点**。

- 通过分析**闪烁点与背景的亮度差异**，区分出可见闪烁点。
- 若闪烁点的**对比度超过设定阈值**，则视为**可见闪烁点**。

![闪烁可见性图表](sparkle-visibility-graph.png)

该阈值基于**人眼可见性公式**，结合以下因素：
- **闪烁点亮度**
- **背景亮度**
- **闪烁点大小**
- **观察距离**

---

### 计算可见闪烁点数量

识别所有可见闪烁点后，统计测量区域内的闪烁点总数。

该测量方法可**精准量化闪烁效应的视觉影响**，用于材料研发和质量控制。
