# エフェクト仕上げモジュール

エフェクト仕上げモジュールは、エフェクト顔料を含む素材に見られるきらめきと粒状感を定量化します。

## 粒状感

粒状感とは、拡散照明条件下で表面に非均一な粒状のパターンとして認識される視覚的な質感です。

これは、表面全体にわたる明るさや暗さの微妙な変化として現れ、粒状または粗い外観を与えます。

この質感は、さまざまな方向に光を散乱させるエフェクト顔料を含む素材で特に顕著です。

| 粒状感 | 表面の状態    | 説明/認識                           |
|-----|----------|---------------------------------|
| <1  | 滑らかな外観   | 非常に少ない粒状感 - 拡散照明条件下で表面は均一な色に見える |
| 1-3 | 細かい粒状    | 拡散条件下で細かい粒が見える                  |
| 3-6 | 粗い外観     | 拡散照明条件下で粒状感が明らか                 |
| 6+  | 非常に粒状の外観 | 非常に粗く、まだらな外観                    |

**測定方法**

表面の固有の色を表す、照明条件、影、反射や陰影などの影響を受けない単一の画像を取得します。

得られた画像の輝度係数の空間的変動を分析し、局所的な反射率の変化を捉える中間的な空間周波数に焦点を当てて、粒状感を定量化します。

粒状感の尺度には、表面の平均輝度を考慮する係数が含まれており、異なる反射率レベルの素材の粒状感を比較することが可能です。この尺度は心理物理的にテストされており、主観的な人間の認識とよく相関することが示されており、さまざまな素材の粒状感を信頼性高く測定できます。

## きらめき

きらめきとは、表面内の鏡のような要素が光を反射する際に観察される視覚的な質感であり、周囲よりも著しく明るい小さな光点として現れ、夜空の星や水面に輝く日光に似ています。

この用語は、方向性のある照明下でこの鮮やかで輝く外観を生み出すエフェクト顔料を含む素材を説明する際によく使用されます。

きらめきは、拡散照明への移行に伴い減少し、完全に拡散した条件下では消失します。

## きらめき密度

きらめき密度は、方向性のある照明条件下で表面に見えるきらめき点の濃度を測定するものであり、各6つの画像の測定フィールド（100mm²、10mm×10mm）内で平均してこれらの明るい点がいくつ見えるかを定量化します。

## きらめきの視認性

Aesthetixは、素材内で視認されたきらめき要素の平均強度値として、きらめきの視認性を報告します。

注：きらめき要素の視覚的な視認性は、光源の明るさに比例します。例えば、強い日光下ではLEDスポットライトよりも要素が明るく、より視認されやすくなります。

## きらめき面積

Aesthetixは、測定フィールド（10mm×10mm）に対応するきらめき面積を、視認されたきらめき要素の平均サイズ値として報告します。

各視認された要素を特定し、そのサイズをピクセル単位で計算し、変換します。

## きらめきの色

**SpR、SpG、SpB**

測定フィールド内のきらめき要素の平均色のRGB値

## 測定方法

**画像取得**

表面の6つの画像を取得し、それぞれを45°リングライトの1つで照らします。

| 例えば、右側から（LED 1）            | および左側から（LED 4）             |
|----------------------------|----------------------------|
| ![LED 1](sparkle-led1.png) | ![LED 4](sparkle-led4.png) |

これらの画像は、10mm×10mmの矩形（赤い領域）内で、特定の方向性のある照明（LED 1-6）下での表面の各点の明るさを記録します。

LEDは、以下の選択ボックスに示すように、グラフ内で色分けされており、同様の色が反対のLEDを示しています。例えば、マゼンタ（LED 1およびLED 4）

![LEDの選択](sparkle-led-selection.png)

**きらめき点の特定**

きらめき点は、周囲の背景よりも著しく明るい領域を区別することによって画像内で特定されます。

![きらめきの視認性グラフ](sparkle-visibility-graph.png)

きらめき点は、そのコントラストが背景に対して特定の閾値を超える場合、「視認可能」と見なされます。

この閾値は、きらめき点の輝度、背景輝度、きらめき点のサイズ、視認距離などの要素を組み込んだ視認性の式によって決定されています。

**視認可能なきらめき点のカウント**

視認可能なきらめき点が特定されると、画像内のこれらの点の総数がカウントされます。
