# Cross-cut Module
Aesthetix Cross-cut Module replaces the subjective visual analysis of cross-cut panels with reproducible imaging measurement.

In the paint and coatings industry, adhesion is a critical property that determines the durability and performance of a coating under various conditions.

In the paint and coatings industry, adhesion is a critical property that determines the durability and performance of a coating under various conditions.\
The Cross-cut Test, standardized by ISO (International Organization for Standardization) under ISO 2409, is a widely recognized method for evaluating the adhesion of a coating to a substrate.

## Why Cross-cut Testing is Important

### Adhesion as a Key Quality Indicator
Coatings are applied to protect surfaces from environmental damage, corrosion, or wear, and to enhance aesthetics. A coating's ability to adhere strongly to a substrate ensures it performs its intended function over time without peeling, flaking, or detaching.

### Reliability Across Industries
Cross-cut testing is used globally to ensure coatings meet consistent quality and performance standards. It helps manufacturers, contractors, and end-users to validate product reliability, regardless of the substrate type or environmental conditions.

### Ease and Precision
The test involves making a grid of cuts (cross-cuts) through the coating down to the substrate using a specialized cutting tool. After the grid is created, adhesive tape is applied and removed to assess the coating's adhesion based on the extent of detachment or flaking observed in the cut areas. The results are graded on a numerical scale, making it a simple yet precise evaluation method.

### Standardized Benchmarking
By following the ISO 2409 standard, the test provides a clear benchmark for comparing coating performance. This helps in quality control, product development, and ensuring compliance with industry regulations.

## Cross-cut Testing with Aesthetix
The Aesthetix device leverages the principles of the ISO Cross-cut Test to provide accurate and repeatable measurements of cross-cuts, not being subject to daily form.\
With Aesthetix, users can efficiently and neutrally assess the durability of their coatings, ensuring they meet both performance expectations and industry standards. This empowers paint and coating professionals to achieve superior product performance and durability.

## Cross-cut Properties
The standard method for ISO 2409 proposes to cut six horizontal and six vertical lines.

The Default setting for Appearance Elements is to use this setup with a cut spacing of 2.0 mm, a cut thickness of 0.2mm and a detection threshold of 10%.

![Crosscut default properties](crosscut-default-properties.png)

### Cut Spacing
Cut Spacing (also called line spacing) is the distance between the centers of nearby cut lines.
### Cut Thickness 
Cut Thickness is how wide each cut line is.
### Cut Detection Threshold
Cut Detection Threshold controls how the system tells the difference between areas with coating and areas where the 
coating has been removed. The system starts with an automatic guess based on image brightness. 
#### Purpose:
This setting helps fine-tune the system’s guess so it better separates coated from uncoated areas. It’s especially 
useful near the edges where the coating may only be partly removed.
- Raise the threshold to include more subtle changes—this helps catch areas where the coating was lightly removed.
- Lower the threshold to ignore faint signals or small amounts of leftover coating—this helps avoid marking coated areas
as removed.
#### When to adjust:
Adjust the Cut Detection Threshold if the automatic setting makes mistakes, such as:
- Marking coated areas as removed, or
- Missing areas where the coating was actually removed.
Make small changes and check the results to get the best separation between coated and uncoated regions.


### Manual Measurement Method
After setting the properties of the cross-cut detection, the preview will display the cross-cut grid.

![Crosscut preview with grid](crosscut-preview-with-grid.png)

<tip>The white grid in the preview will mirror the settings in properties and will only appear after you have taken at least one measurement.</tip>

Please arrange the grid and the cross-cut image as close as possible, as only a matching overlay would ensure a perfect result. If you see that your grid does not match, please modify the properties accordingly.

Ideal results should look like as in the images below; note that the images show detected remaining coating in green overlay color:

![Crosscut example 1](crosscut-example-1.png) ![Crosscut example 2](crosscut-example-2.png)

If you are experiencing issues with the selection of remaining coating, please adjust the Cut Detection Threshold until the resulting overlay is covering the area correctly.

## Testing Coatings with Low Absorption Against the Substrate

For samples having a brighter coating compared to the substrate, you might be experiencing issues.

In this case, it might help to use the “Invert Map” setting, to differentiate the cross cut by inverting the image and then performing the analysis. 