# 划格法测试模块（Cross-cut Module）

Aesthetix 划格法测试模块取代了对划格板的主观视觉分析，提供可重复的成像测量。

在油漆和涂料行业，**附着力**是决定涂层耐久性和性能的关键特性。

划格法测试（Cross-cut Test）由 **ISO 2409** 标准化，是评估涂层与基材附着力的广泛认可方法。

---

## **为什么划格法测试很重要？**

### **附着力作为关键质量指标**
涂层用于**保护表面**免受环境损害、腐蚀或磨损，同时提升**美观性**。  
涂层能否**牢固附着**于基材决定了其长期性能，防止剥落、脱落或分层。

### **适用于各行业的可靠性评估**
划格法测试可确保**全球涂层质量和性能的一致性**，  
广泛应用于制造商、承包商和最终用户，以验证产品在不同基材和环境条件下的可靠性。

### **测试方法简单且精确**
测试过程包括：
1. **使用专用切割工具** 在涂层上刻划出**网格状切口（划格）**，直达基材。
2. **粘贴并撕除胶带**，评估切割区域涂层的脱落程度。
3. 结果按照 **数值等级** 进行评估，方法简洁，结果可靠。

### **标准化基准测试**
依据 **ISO 2409 标准** 进行测试，可**清晰对比不同涂层性能**，  
有助于**质量控制、产品开发**，确保符合行业法规。

---

## **Aesthetix 划格法测试**
Aesthetix 设备基于 **ISO 划格法测试原理**，提供**精准、可重复的测量**，避免主观误差。  
Aesthetix 让用户能够**高效、公正地评估涂层耐久性**，确保产品符合行业标准，  
帮助涂料和油漆专业人士**提升产品质量和耐用性**。

---

## **划格测试参数**
ISO 2409 标准要求**刻划 6 条水平线和 6 条垂直线**，形成网格。  
Appearance Elements 默认参数：
- **刻划间距**：2.0 mm
- **刻划厚度**：0.2 mm
- **检测阈值**：10%

![划格法默认参数](crosscut-default-properties.png)

- **刻划间距（Cut Spacing）**：刻划线中心之间的距离。
- **刻划厚度（Cut Thickness）**：实际刻划线的宽度。
- **切割检测阈值（Cut Detection Threshold）**：调整此值以区分**残留涂层**和**剥离涂层**。

---

## **手动测量方法**
设置划格检测参数后，预览将显示**划格网格**。

![划格法预览](crosscut-preview-with-grid.png)

<tip> 预览中的白色网格会与参数设置匹配，至少完成一次测量后才会显示。 </tip>

**确保网格与划格图像完全对齐**，否则测量结果可能不准确。  
如果网格不匹配，请调整相应的参数。

**理想测试结果示例（绿色叠加区域为检测到的残留涂层）：**  
![划格法示例 1](crosscut-example-1.png) ![划格法示例 2](crosscut-example-2.png)

如果**残留涂层检测不准确**，请调整 **切割检测阈值（Cut Detection Threshold）**，直到叠加区域正确覆盖划格区域。

---

## **测试基材吸收率较低的涂层**
如果涂层颜色**比基材更亮**，可能会影响检测效果。  
此时，可以启用 **“反转映射（Invert Map）”** 选项，  
使软件对图像进行反转分析，以正确识别划格区域。
