# クロスカットモジュール

Aesthetixクロスカットモジュールは、目視で主観的に評価されていたクロスカット試験のパネルを、再現性の高い画像測定で置き換えます。

塗料やコーティング業界において、密着性（付着性）は、さまざまな条件下でのコーティングの耐久性や性能を決定する重要な特性です。

ISO（国際標準化機構）が標準化した「クロスカット試験（ISO 2409）」は、コーティングと基材の密着性評価で広く認知されている方法です。

## クロスカット試験の重要性

### 品質を示す重要な指標としての密着性
コーティングは表面を環境損傷、腐食、摩耗から保護し、美観を向上させるために施されます。コーティングが基材にしっかりと付着することで、剥離やひび割れを起こさず、長期的に性能を維持します。

### 幅広い産業での信頼性
クロスカット試験は、コーティングが世界的な品質と性能基準を満たしていることを確認するために広く用いられます。これにより製造業者や施工業者、エンドユーザーは、基材の種類や環境条件にかかわらず製品の信頼性を検証できます。

### 容易かつ正確な測定
この試験では、特殊なカッターでコーティングを基材に達するまで格子状にカットします。その後、粘着テープを貼って剥がし、格子状の切断部分での塗膜の剥離やフレーキングの程度に基づいて密着性を評価します。結果は数値的尺度で評価され、シンプルながら正確な評価法です。

### 標準化されたベンチマーク
ISO 2409に従うことで、コーティング性能の比較に明確な基準が提供されます。これにより、品質管理、製品開発、規制適合の確認に役立ちます。

## Aesthetixを使用したクロスカット試験
AesthetixはISOクロスカット試験の原理を利用して、クロスカットの正確で再現性のある測定を提供します。目視評価と異なり、日々の体調に左右されません。  
Aesthetixを用いることで、コーティングの耐久性を効率よく客観的に評価し、性能基準および業界標準への適合性を確認できます。これにより塗料・コーティング業界の専門家は、製品の性能と耐久性を向上させることが可能になります。

## クロスカットのプロパティ（設定値）
ISO 2409の標準的な方法では、水平6本・垂直6本のカットラインを使用します。

Appearance Elementsのデフォルト設定は、この標準設定を採用し、カット間隔は2.0 mm、カット厚さは0.2 mm、検出閾値（しきいち）は10%に設定されています。

![Crosscut default properties](crosscut-default-properties.png)

「カット間隔」（Cut Spacing）とはカットラインの中心間の距離、「カット厚さ」（Cut Thickness）とは実際に切断するラインの幅を指します。  
「カット検出閾値」を調整すると、残存塗膜と剥離塗膜を適切に分離できます。

### 手動での測定方法
クロスカット検出のプロパティを設定すると、プレビュー画面にクロスカットのグリッドが表示されます。

![Crosscut preview with grid](crosscut-preview-with-grid.png)

<tip>プレビュー画面の白いグリッドは、プロパティの設定を反映しており、少なくとも一回の測定を行った後にのみ表示されます。</tip>

正確な結果を得るには、表示されるグリッドとクロスカット画像を可能な限り正確に重ね合わせてください。もしグリッドが画像と一致しない場合は、プロパティを適宜調整してください。

以下の画像が理想的な結果例です。緑色のオーバーレイは、検出された残存塗膜を示しています。

![Crosscut example 1](crosscut-example-1.png) ![Crosscut example 2](crosscut-example-2.png)

残存塗膜の選択に問題がある場合は、オーバーレイが適切な領域をカバーするまで、「カット検出閾値」を調整してください。

## 基材と塗膜のコントラストが低い場合の測定方法
基材に対して明るい塗膜を持つサンプルでは、測定が難しくなる場合があります。

この場合は、「マップを反転（Invert Map）」設定を使用することで、画像を反転させてクロスカット部分を明確化し、解析を実施するとよいでしょう。
