# Adjusting Texture Parameters
## **Adjusting Parameters for Effective Feature Selection**
Adjusting texture measurement parameters allows specific cells visible in the pattern to be identified and counted.

### 1. Feature Separation (Watershed Morphology)

- **Purpose:** This parameter controls the "erosion" of segmented blobs by increasing the gap between detected features (e.g., hills) on the surface. It helps separate touching features, ensuring distinct detection.
- **How It Works:**
    - Increasing this value will separate closely connected features, increasing the number of distinct features identified.
    - However, if set too high, smaller features may be entirely eroded and lost from the analysis.
- **Adjustment Steps:**
  1. Start with a moderate value and visually inspect the segmentation results.
  2. Gradually increase the value to separate touching features while ensuring small, meaningful features are not eliminated.
  3. Recalculate the analysis after each adjustment to evaluate its impact.


### 2. Feature Selection (Watershed Selection Percentage)
- **Purpose:** This parameter determines the minimum size of features (hills) to include in the analysis after separation.
- **How It Works:**
    - A higher value excludes smaller, unwanted features, focusing only on larger, significant ones.
    - A lower value includes smaller features, which might be noise or irrelevant depending on your application.
- **Adjustment Steps:**
  1. Start with a low percentage to include all potential features.
  2. Gradually increase the value to exclude smaller, less relevant features until only meaningful ones remain.
  3. Visually inspect the results to ensure no critical features are excluded.

### 3. Threshold
- **Purpose**: This parameter sets the threshold level used by the watershed algorithm during segmentation.
- **How It Works**:
  - The threshold level determines how the algorithm distinguishes between different features based on altitude.
  - The range is from -1.0 to 1.0, with 0.0 representing the mean level between the minimum and maximum detected altitude.
  - Adjusting this value can influence how hills and valleys are identified and separated.
- **Adjustment Steps**:
  1. Begin by visually inspecting the initial segmentation results using the default threshold.
  2. Modify the watershed parameters, including the threshold, and observe the effect on feature detection and segmentation.
  3. Adjust the threshold value incrementally and recalculate the analysis to evaluate its impact on the segmentation accuracy.
  4. Ensure the segmentation correctly represents the features relevant to your analysis.

### 4. Area Crop (X/Width and Y/Height)
- **Purpose**: This allows you to define and analyze a smaller region of interest (ROI) within the total measurement area. This can be advisable for certain applications, such as analyzing steel or metallized surfaces, or to avoid damages or over-illumination at the edges of the default area.
- **How It Works**:
  - You specify the desired width and height of the rectangular area to be analyzed.
  - By default, the area is centered within the total 10.00mm x 10.00mm field of measurement (max 15.00mm x 15.00mm).
  - Cutting the area of interest has a direct influence on the texture parameters calculated, except for gloss.
- **Adjustment Steps**:
  1. Visually inspect the surface image and initial results to determine if an area crop is needed.
  2. If required, specify the desired width and height in mm.
  3. Select "Set" to apply the new area boundaries.
  4. Recalculate the analysis after each adjustment to evaluate its impact.

### 5. Invert Feature Map
- **Purpose:** Selecting this option inverts the feature map
- **How It Works:**
    - The map is virtually flipped upside down, hills become valleys and visa versa.
    - This is used to segment surfaces in which the borders between the features are positive rather than negative.
    - This is often used for surfaces with raised edges between the features.


## Practical Workflow for Parameter Adjustment

1. **Visual Inspection:** Begin by inspecting the initial segmentation results to identify areas where features are not well-separated or where irrelevant small features are included.
2. **Adjust Feature Separation:**
    - Increase this parameter incrementally to improve separation of touching regions.
    - Avoid setting it too high to prevent losing smaller but important features.
3. **Adjust Feature Selection:**
    - Modify this parameter to filter out small, insignificant features while retaining larger ones relevant to your analysis.
3. **Invert Feature Map:**
    - Select this control if segmentation is not replicating the borders between visible features, often required for complex geometric patterns or materials with negative features.  
4. **Recalculate and Evaluate:** After each adjustment, recalculate the segmentation and recheck the results for accuracy and completeness.


## **Key Tips for Optimal Results**

- Use a balanced approach: Adjust both parameters iteratively rather than focusing on one in isolation.
- Test different combinations of values to find an optimal setting for your specific surface texture and feature requirements.
- Always visually inspect results after adjustments to ensure meaningful segmentation.

By carefully tweaking these parameters, users can achieve precise feature selection tailored to their surface analysis needs.
