# 调整纹理参数

## **调整参数以优化特征选择**
调整纹理测量参数可帮助识别并计数图案中的特定单元，使测量更符合实际需求。

---

## **1. 特征分离（分水岭形态学调整）**

- **目的**：控制分割区域的“侵蚀”程度，通过**增加相邻特征（如凸起）之间的间距**，确保正确识别相互接触的特征。
- **工作原理**：
    - **增加特征分离值** → 使相邻特征分开，提高检测的独立性。
    - **设置过高** → 可能导致较小的特征完全消失，影响分析完整性。
- **调整步骤**：
    1. 先使用**中等数值**并观察分割效果。
    2. 逐步提高数值，确保粘连的特征能够分离，同时避免小特征被误删除。
    3. 每次调整后**重新计算分析**，评估调整对特征识别的影响。

## **2. 特征选择（分水岭选择百分比）**

- **目的**：确定分割后的特征**最小尺寸阈值**，决定哪些特征被纳入分析。
- **工作原理**：
    - **数值较高** → 过滤掉较小的特征，仅保留较大的显著特征。
    - **数值较低** → 包括较小的特征，可能包含噪点或无关信息。
- **调整步骤**：
    1. 先使用**较低的阈值**，确保所有可能的特征都被检测到。
    2. 逐步提高该值，以排除较小、不相关的特征，保留重要特征。
    3. **可视化检查**调整后的结果，确保没有遗漏关键特征。

### 3. 阈值
- **目的**：此参数用于设置分割过程中分水岭算法使用的阈值水平。
- **工作原理**：
    - 阈值水平决定算法如何根据高度来区分不同的特征。
    - 范围为 -1.0 到 1.0，其中 0.0 表示检测到的最小和最大高度之间的平均水平。
    - 调整此值可以影响算法如何识别和分离丘陵与低谷。
- **调整步骤**：
    1. 首先使用默认阈值，视觉检查初始分割结果。
    2. 修改包括阈值在内的分水岭参数，并观察其对特征检测与分割的影响。
    3. 逐步调整阈值，并重新计算分析以评估其对分割准确性的影响。
    4. 确保分割结果能够正确地反映与分析相关的特征。

### 4. 区域裁剪（X/宽度 和 Y/高度）
- **目的**：此功能允许你在整个测量区域中定义并分析一个较小的感兴趣区域（ROI）。这在某些应用中非常有用，例如分析钢铁或金属化表面，或避免在默认区域边缘产生损伤或过度照明。
- **工作原理**：
    - 你可以指定希望分析的矩形区域的宽度和高度。
    - 默认情况下，该区域在整个 10.00mm x 10.00mm 的测量范围内居中（最大可达 15.00mm x 15.00mm）。
    - 裁剪感兴趣区域会直接影响所计算的纹理参数，光泽度除外。
- **调整步骤**：
    1. 视觉检查表面图像和初始结果，判断是否需要裁剪区域。
    2. 如有需要，输入希望的宽度和高度（单位：毫米）。
    3. 选择“设置”以应用新的区域边界。
    4. 每次调整后重新进行分析以评估其影响。

## **5. 反转特征地图**

- **目的**：反转表面特征的高低关系，使**凸起变为凹陷，凹陷变为凸起**。
- **工作原理**：
    - 适用于**边界呈凸起结构的表面**，例如带有**网格、凹槽或浮雕**特征的材料。
    - 反转后，系统会将边界区域视为主特征，而不是分隔特征的低谷区域。

---

## **参数调整的实际操作流程**

1. **初步检查**
    - 观察初始分割结果，判断是否存在**特征未正确分离**或**无关小特征被包含**的情况。

2. **调整特征分离**
    - 逐步提高该参数，确保相邻区域得到有效分割。
    - 避免设置过高，以防有价值的小特征被误删。

3. **调整特征选择**
    - 调整该值，排除微小、不重要的特征，同时保留关键特征。

4. **反转特征地图（如适用）**
    - **若分割结果未能正确识别边界**，可尝试启用“反转特征地图”功能，以优化特征识别。

5. **重新计算并检查**
    - 每次调整后，**重新计算测量**，确保优化后的分割结果符合实际需求。

---

## **优化测量结果的关键技巧**

✔ **采用平衡调整策略**
- 交替调整**特征分离**和**特征选择**，避免只关注单个参数。

✔ **测试不同组合参数**
- 不同表面纹理可能需要不同的参数设定，建议**逐步测试并优化**。

✔ **实时可视化检查**
- 观察调整后的分割结果，确保检测到的特征符合预期。

**通过优化这些参数，用户可以精确选择和分析表面特征，提升纹理测量的准确性和一致性。**
