# テクスチャパラメータの調整

## **特徴選択を効果的に行うためのパラメータ調整**

テクスチャ測定パラメータを調整することで、パターン内で確認できる特定のセルを識別・計測できます。

### **1. 特徴分離（ウォーターシェッド形態制御）**

- **目的：**  
  このパラメータは表面上で検出された特徴（例：凸部）の間隔を広げ、隣接した特徴を分離するための「エロージョン（侵食処理）」を制御します。これにより接触している特徴を分離し、明確に識別できます。

- **動作原理：**
    - この値を大きくすると、隣接した特徴がより明確に分離され、識別される特徴の数が増えます。
    - しかし、高く設定しすぎると、小さな特徴が完全に侵食されて解析から失われる場合があります。

- **調整手順：**
    1. 初めは中程度の値で開始し、分離結果を視覚的に確認します。
    2. 徐々に値を増やして隣接する特徴を分離しますが、小さな重要な特徴が消えないよう注意します。
    3. 各調整後に再解析を行い、結果への影響を確認します。

### **2. 特徴の選択（ウォーターシェッド選択率）**

- **目的：**  
  このパラメータは、分離後の解析に含める特徴（凸部）の最小サイズを決定します。

- **動作原理：**
    - 値を大きくすると、小さく不要な特徴が除外され、大きく重要な特徴に集中します。
    - 値を小さくすると、小さな特徴（ノイズや不要なものも含む）が解析に含まれます。

- **調整手順：**
    1. 最初は低い割合で開始し、全ての潜在的な特徴を含めます。
    2. 徐々に値を上げ、小さく重要でない特徴を除外し、有意義な特徴のみを残します。
    3. 結果を視覚的に確認し、重要な特徴が除外されていないか確認します。

### 3. 閾値
- **目的**：このパラメータは、セグメンテーション中にウォーターシェッドアルゴリズムが使用する閾値レベルを設定します。
- **動作の仕組み**：
    - 閾値レベルは、高さに基づいてアルゴリズムが異なる特徴を区別する方法を決定します。
    - 範囲は -1.0 から 1.0 で、0.0 は検出された最小高さと最大高さの間の平均レベルを表します。
    - この値を調整することで、丘や谷の識別および分離の仕方に影響を与えることができます。
- **調整手順**：
    1. まずはデフォルトの閾値を使用して初期のセグメンテーション結果を視覚的に確認します。
    2. 閾値を含むウォーターシェッドパラメータを変更し、特徴の検出とセグメンテーションへの影響を観察します。
    3. 閾値を段階的に調整し、その都度分析を再計算して、セグメンテーションの精度への影響を評価します。
    4. 分割結果が分析に関連する特徴を正しく表していることを確認します。

### 4. エリアクロップ（X/幅 および Y/高さ）
- **目的**：この機能では、全体の測定エリア内で、関心領域（ROI）を定義して分析できます。これは、例えば鋼や金属化表面の分析、あるいはデフォルト領域の端での損傷や過度な照明を避けるために有効です。
- **動作の仕組み**：
    - 分析する長方形の領域の幅と高さを指定します。
    - デフォルトでは、この領域は10.00mm x 10.00mmの測定範囲内の中央に配置されます（最大で15.00mm x 15.00mm）。
    - 関心領域を切り出すと、光沢を除くテクスチャパラメータの計算に直接影響します。
- **調整手順**：
    1. 表面画像および初期結果を視覚的に確認し、エリアクロップが必要かどうかを判断します。
    2. 必要であれば、希望する幅と高さをmm単位で指定します。
    3. 「設定」を選択して、新しいエリアの境界を適用します。
    4. 各調整後に分析を再計算して、その影響を評価します。

### **5. 特徴マップの反転（Invert Feature Map）**
- **目的：**  
  このオプションを選択すると、特徴マップが反転します。

- **動作原理：**
    - 特徴マップが上下反転され、凸部が凹部に、凹部が凸部になります。
    - これは特徴間の境界が凹型ではなく凸型の表面のセグメンテーションに使用されます。
    - 特に、特徴間に隆起したエッジを持つ表面に頻繁に使用されます。

## **パラメータ調整の実践的ワークフロー**

1. **視覚的確認：**  
   最初のセグメンテーション結果を目視し、特徴がうまく分離されていない部分や、無関係な小さい特徴が含まれている部分を特定します。

2. **特徴分離の調整：**
    - このパラメータを少しずつ増やして、接触した領域の分離を改善します。
    - 重要な小さな特徴が失われないよう、高く設定しすぎないように注意します。

3. **特徴選択の調整：**
    - 解析に関係のない小さな特徴を除外し、重要な大きさの特徴だけを残すようパラメータを調整します。

4. **特徴マップの反転：**
    - 特徴間の境界が適切に検出されない場合や、複雑な幾何学模様・凹凸が逆の表面の場合は、このオプションを選択します。

5. **再計算と評価：**
    - 各調整後にセグメンテーションを再計算し、結果が正確で完全か確認します。

## **最適な結果を得るための重要なポイント**

- バランスよくアプローチすること。片方のパラメータだけに偏らず、両方のパラメータを交互に調整します。
- 異なる組み合わせを試して、対象の表面テクスチャや解析目的に最適な設定を見つけてください。
- 調整後は必ず目視で結果を確認し、有意義なセグメンテーションができているかを確かめます。

これらのパラメータを注意深く調整することで、表面解析のニーズに適した精密な特徴選択が可能になります。
