# 调整抛光质量参数

此模块通过分析 10° 角度的高强度光斑反射图像来识别漆面中的旋涡纹、擦痕和全息纹。算法基于缺陷的对比度与背景亮度的差异，自动选择可见的线性缺陷。

## 1. 灵敏度（Sensitivity）

- **目的**：控制算法检测线性缺陷的阈值，基于其可见性（与背景的对比度）。
- **选项**：最低、低、中等、高、最高
- **工作原理**：
    - **更高的灵敏度**：可检测更微小的缺陷，但可能包含误判（噪点）。
    - **更低的灵敏度**：仅检测更明显的缺陷，但可能遗漏细微问题。
- **调整步骤**：
    1. 从 "最低" 灵敏度开始。
    2. 如果某些关键缺陷未被检测到，提高灵敏度级别。
    3. 观察检测结果，避免过多误判。

---

## 2. 最小长度（Minimum Length）

- **目的**：设置检测缺陷的最小长度，单位为微米（µm）。
- **工作原理**：
    - **较大值**：过滤掉较小的缺陷，仅关注更严重的问题。
    - **较小值**：允许检测更短的划痕和旋涡纹，但可能会增加噪点检测。
- **调整步骤**：
    1. 以默认值（100 微米）作为起点。
    2. 若需检测更短的缺陷，降低该值。
    3. 若需仅关注更显著的缺陷，增加该值。
    4. 根据产品质量要求优化设定，确保检测到符合标准的缺陷类型。

---

## 3. 遮罩半径（Mask Radius）

- **目的**：排除高强度光斑的直接反射区域，以免干扰缺陷检测。
- **调整方法**：
    1. 默认半径适用于光滑的镜面反射表面。
    2. 如果表面雾影或抛光痕迹增大了反射光斑尺寸，并干扰了缺陷检测，则增加遮罩半径。
    3. 观察检测结果，确保排除区域足够，但不过度屏蔽潜在缺陷。

---
通过合理调整这些参数，可以优化缺陷检测结果，确保对抛光质量的精准评估，同时避免误判和遗漏关键缺陷。
