# 研磨品質パラメータの調整

このモジュールは、**10度の角度で配置された高輝度スポット光の反射画像を解析**し、塗装表面の**スワール、ホログラム、研磨マーク**を識別します。  
アルゴリズムは、**背景の輝度とのコントラストに基づいて線状の欠陥を選択**します。

---

### **1. 感度（Sensitivity）**

- **目的**：背景とのコントラストに基づき、線状の欠陥を検出する閾値を制御します。
- **オプション**：最低（Lowest）、低（Low）、中（Moderate）、高（High）、最高（Highest）
- **動作原理**：
    - **感度を高く**すると、微細な欠陥も検出できますが、**誤検出（False Positives）**が増える可能性があります。
    - **感度を低く**すると、より目立つ欠陥にフォーカスできますが、**細かい欠陥を見逃す**可能性があります。
- **調整手順**：
    1. 最初は **「最低（Lowest）」** に設定します。
    2. 重要な欠陥が検出されない場合は、感度を上げて調整します。

---

### **2. 最小長（Minimum Length）**

- **目的**：解析に含める欠陥の最小サイズ（単位：ミクロン）を設定します。
- **動作原理**：
    - **値を大きく**すると、小さな欠陥を除外し、**より深刻な欠陥に集中**できます。
    - **値を小さく**すると、**微細な欠陥も検出**されますが、不要なマークも検出される可能性があります。
- **調整手順**：
    1. 品質基準に基づき、**中程度の値**（デフォルトは**100ミクロン**）で開始します。
    2. **より短い欠陥を検出する**必要がある場合は、値を下げます。
    3. **より大きな欠陥のみに集中**したい場合は、値を上げます。
    4. **製品品質基準に適した欠陥の典型的なサイズ**に基づいて調整します。

---

### **3. マスク半径（Mask Radius）**

- **目的**：解析から**高輝度スポット光の直接反射を除外**します。

1. **デフォルトの半径**では、**滑らかな鏡面仕上げ**の反射スポットを除外します。
2. **表面ヘイズや研磨マークにより反射スポットが拡大し、欠陥検出を妨げる場合**は、マスク半径を**大きく**設定します。
